capture log close

log using analysis_long.smcl, replace

***************************************************
* effect of expectations about pension collection
use complete_selected, clear

xtset pid wave
g employed=f1.em_employment==2 if wave==1 | wave==4 | wave==5
replace employed=. if (f1.em_employment==. | f1.em_employment==.a | f1.em_employment==.b) & (wave==1 | wave==4 | wave==5)
replace employed=f2.em_employment==2 if wave==2
replace employed=. if (f2.em_employment==. | f2.em_employment==.a | f2.em_employment==.b) & wave==2

g employedFT=(f1.em_employment==2 & f1.parttime==0) if wave==1 | wave==4 | wave==5
replace employedFT=. if (f1.em_employment==. | f1.em_employment==.a | f1.em_employment==.b | (f1.em_employment==2 & f1.parttime==.)) ///
						& (wave==1 | wave==4 | wave==5)
replace employedFT=(f2.em_employment==2 & f2.parttime==0) if wave==2
replace employedFT=. if (f2.em_employment==. | f2.em_employment==.a | f2.em_employment==.b | (f2.em_employment==2 & f2.parttime==.)) ///
						& wave==2

g employedPT=(f1.em_employment==2 & f1.parttime==1) if wave==1 | wave==4 | wave==5
replace employedPT=. if (f1.em_employment==. | f1.em_employment==.a | f1.em_employment==.b | (f1.em_employment==2 & f1.parttime==.)) ///
						& (wave==1 | wave==4 | wave==5)
replace employedPT=(f2.em_employment==2 & f2.parttime==1) if wave==2
replace employedPT=. if (f2.em_employment==. | f2.em_employment==.a | f2.em_employment==.b | (f2.em_employment==2 & f2.parttime==.)) ///
						& wave==2

g int_year_final=f.int_year if wave==1 | wave==4 | wave==5
replace int_year_final=f2.int_year if wave==2

foreach var in log_hy log_hnetw dm_age_years dm_ghealth dm_hsize2 dm_marstatus2 {
	g F`var'=f.`var' if wave==1 | wave==4 | wave==5
	replace F`var'=f2.`var' if wave==2
}

global XVAR c.log_hy c.log_hnetw i.dm_age_years i.Fdm_age_years i.dm_gender i.em_mainjob_type i.parttime ///
	i.dm_education i.dm_citizen i.dm_ghealth i.Fdm_ghealth i.dm_marstatus2 i.dm_hsize2 i.Fdm_hsize2 i.int_year_final ///
		i.country i.int_year_final#i.country
		
capture drop select*
* Waves 1-2
g select1=(em_employment==2 & wave==1 & dm_age_years>=50 & dm_age_years<65)
* Waves 2-4
g select2=(em_employment==2 & wave==2 & dm_age_years>=50 & dm_age_years<65)
* Waves 4-5
g select4=(em_employment==2 & wave==4 & dm_age_years>=50 & dm_age_years<65)
* Exclude Germany and Sweden, wave 4
tab country select4 if ex_gov_red_pen!=.
replace select4=0 if wave==4 & (country==12 | country==13)
* Waves 5-6
g select5=(em_employment==2 & wave==5 & dm_age_years>=50 & dm_age_years<65)

g select=select1==1 | select2==1 | select4==1 | select5==1

* REFORMS -> ACTUAL BEHAVIOUR
sum ex_gov_age_incr ex_gov_red_pen employed employedFT employedPT $XVAR if select==1 & employed!=. & employed!=.a & employed!=.b ///
	& ex_gov_age_incr>=0 & ex_gov_age_incr<=1 & ex_gov_red_pen>=0 & ex_gov_red_pen<=1

reg employed ex_gov_age_incr ex_gov_red_pen $XVAR if select==1, cluster(hhid_current)
est store reforms

xtset pid wave
quietly xtreg employed ex_gov_age_incr ex_gov_red_pen $XVAR if select==1, cluster(init_hhid) fe
	g x1=e(sample)==1
	egen tot_x1=sum(x1), by(mergeid)
xtreg employed ex_gov_age_incr ex_gov_red_pen $XVAR if x1==1 & tot_x1>1, cluster(init_hhid) fe
est store reformsFE
drop x1 tot_x1

reg employedFT ex_gov_age_incr ex_gov_red_pen $XVAR if select==1 & parttime==0, cluster(hhid_current)
est store reformsFT

quietly xtreg employedFT ex_gov_age_incr ex_gov_red_pen $XVAR if select==1 & parttime==0, fe cluster(init_hhid)
	g x1=e(sample)==1
	egen tot_x1=sum(x1), by(mergeid)
xtreg employedFT ex_gov_age_incr ex_gov_red_pen $XVAR if x1==1 & tot_x1>1, fe cluster(init_hhid)
est store reformsFTFE
drop x1 tot_x1

/* TABLE A.5*/
esttab  reforms reformsFE reformsFT reformsFTFE using "$output/tableA_5.csv", /// 		
	b(%7.3f) se(%7.3f) r2 scalars(N) keep(ex_gov_age_incr ex_gov_red_pen) ///
	starlevels(* .10 ** .05 *** .01)   ///
	label title ("Estimates (coefficients)") mtitles("OLS" "FE" ///
	"FT OLS" "FT FE") ///
	nogaps replace

log close
